<?php

if(isset($_POST["submit"])) {
    $target_dir = "uploads/";
    $target_file = $target_dir . basename($_FILES["fileToUpload"]["name"]);
    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));

    // ... (your existing code)

    if ($uploadOk == 1) {
        if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $target_file)) {
            echo "The file ". htmlspecialchars( basename( $_FILES["fileToUpload"]["name"])). " has been uploaded.";

            // Check if it's a PDF or an image
            if ($imageFileType === "pdf") {
                // Handle PDF
                echo "PDF uploaded.";
                // Implement PDF processing here
            } else {
                // Handle image
                require 'vendor/autoload.php'; // Include the Guzzle library

                // Azure API credentials
                $subscriptionKey = 'YOUR_SUBSCRIPTION_KEY';
                $endpoint = 'YOUR_API_ENDPOINT';

                // Prepare request headers and body
                $headers = [
                    'Ocp-Apim-Subscription-Key' => $subscriptionKey,
                    'Content-Type' => 'application/octet-stream',
                ];

                $body = fopen($target_file, 'r');

                // Send request to Azure Computer Vision API
                $client = new GuzzleHttp\Client();
                $response = $client->request('POST', $endpoint . '/vision/v3.1/ocr', [
                    'headers' => $headers,
                    'body' => $body,
                ]);

                // Process API response
                $jsonResponse = json_decode($response->getBody()->getContents(), true);

                // Extracted text from OCR
                $extractedText = '';

                foreach ($jsonResponse['regions'] as $region) {
                    foreach ($region['lines'] as $line) {
                        foreach ($line['words'] as $word) {
                            $extractedText .= $word['text'] . ' ';
                        }
                        $extractedText .= "\n";
                    }
                }

                // Now you can process $extractedText to map the information to your desired variables
                $lines = explode("\n", $extractedText);

                $client_name = "";
                $account_number = "";
                $acc_balance = "";
                $created_date = "";

                foreach ($lines as $line) {
                    // Check for patterns in the text to identify the information
                    if (strpos($line, "Client Name:") !== false) {
                        $client_name = trim(str_replace("Client Name:", "", $line));
                    } elseif (strpos($line, "Account Number:") !== false) {
                        $account_number = trim(str_replace("Account Number:", "", $line));
                    } elseif (strpos($line, "Balance:") !== false) {
                        $acc_balance = trim(str_replace("Balance:", "", $line));
                    } elseif (strpos($line, "Date:") !== false) {
                        $created_date = trim(str_replace("Date:", "", $line));
                    }
                }

                // Display extracted information
                echo "Client Name: $client_name<br>";
                echo "Account Number: $account_number<br>";
                echo "Account Balance: $acc_balance<br>";
                echo "Created Date: $created_date<br>";

                // Now you have the extracted information, you can perform your database operation
                // For example, you can use these variables to insert into your database

                // Close the file stream
                fclose($body);
            }

        } else {
            echo "Sorry, there was an error uploading your file.";
        }
    }
}

?>
