<?php

function generateInvoiceNumber($conn) {
    $prefix = "FAS-";
    
    // Lock the counter to ensure atomicity in case of simultaneous requests
    $conn->query("LOCK TABLES counter WRITE");
    
    // Get the current counter value and increment it
    $result = $conn->query("SELECT counter_value FROM counter");
    $row = $result->fetch_assoc();
    $counter_value = $row['counter_value'];
    
    $counter_value++;
    $conn->query("UPDATE counter SET counter_value = $counter_value");
    
    // Unlock the counter
    $conn->query("UNLOCK TABLES");
    
    // Generate a padded invoice number (e.g., FAS-000001)
    $invoice_number = $prefix . str_pad($counter_value, 6, '0', STR_PAD_LEFT);
    
    return $invoice_number;
}

?>
