<?php
session_start();
include 'includes/dbconn.php'; // Ensure this is the path to your DB connection script

$user_id = $_SESSION['user_id']; // Ensure that user_id is stored in session upon login
$company_id = $_SESSION['company_id'];

// Fetch user, company, and subscription details
$stmt = $conn->prepare("SELECT u.full_name, c.name AS company_name, s.end_date 
                        FROM users u 
                        JOIN companies c ON u.company_id = c.company_id 
                        LEFT JOIN subscriptions s ON u.user_id = s.user_id 
                        WHERE u.company_id = ? 
                        AND u.user_id = ?");
$stmt->bind_param("ii", $company_id, $user_id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

// Calculate the number of days left for the subscription
$subscriptionDaysLeft = "N/A";
if (!empty($data['end_date'])) {
    $endDate = new DateTime($data['end_date']);
    $today = new DateTime();
    $subscriptionDaysLeft = $endDate->diff($today)->format("%a Days");
    if ($endDate < $today) {
        $subscriptionDaysLeft = "Expired";
    }
}

// Close the statement
$stmt->close();
?>


<!-- ========== Left Sidebar Start ========== -->
<div class="left-side-menu">

    <div class="h-100" data-simplebar>

         <!-- User box -->
        <div class="user-box text-center">

            <img src="assets/images/users/user-1.jpg" alt="user-img" title="<?php echo htmlspecialchars($data['full_name']); ?>" class="rounded-circle img-thumbnail avatar-md">
                <div class="dropdown">
                    <a href="#" class="user-name dropdown-toggle h5 mt-2 mb-1 d-block" data-bs-toggle="dropdown" aria-expanded="false">
                        <?php echo htmlspecialchars($data['full_name']); ?>
                    </a>
                    <div class="dropdown-menu user-pro-dropdown">

                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item notify-item">
                            <i class="fe-user me-1"></i>
                            <span>My Account</span>
                        </a>
        
                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item notify-item">
                            <i class="fe-settings me-1"></i>
                            <span>Settings</span>
                        </a>
        
                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item notify-item">
                            <i class="fe-lock me-1"></i>
                            <span>Lock Screen</span>
                        </a>
        
                        <!-- item-->
                        <a href="auth-logout.php" class="dropdown-item notify-item">
                            <i class="fe-log-out"></i>
                            <span>Logout</span>
                        </a>
        
                    </div>
                </div>

            <p class="text-muted left-user-info"><?php echo htmlspecialchars($data['company_name']); ?></p>
            
            <label>Subscription Days Left:</label>
            <p class="text-muted left-user-info"><?php echo $subscriptionDaysLeft; ?> Days</p>
            
            <ul class="list-inline">
                <li class="list-inline-item">
                    <a href="contacts-profile.php" class="text-muted left-user-info">
                        <i class="mdi mdi-cog"></i>
                    </a>
                </li>

                <li class="list-inline-item">
                    <a href="../auth-logout.php">
                        <i class="mdi mdi-power"></i>
                    </a>
                </li>
            </ul>
        </div>

        <!--- Sidemenu -->
        <div id="sidebar-menu">

            <ul id="side-menu">

                <li class="menu-title">Navigation</li>
                
                <li>
                    <a href="index.php">
                        <i class="mdi mdi-view-dashboard-outline"></i>
                        <span> Dashboard </span>
                    </a>
                </li>

                <li class="menu-title mt-2">General Ledger Transactions</li>

                <li>
                    <a href="#transactions" data-bs-toggle="collapse">
                        <i class="mdi mdi-clipboard-outline"></i>
                        <span> Transactions </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="transactions">
                        <ul class="nav-second-level">
                            <li>
                                <a href="create_accounts.php">Create Accounts</a>
                            </li>
                            <li>
                                <a href="create_transaction.php">Record Transactions</a>
                            </li>
                            <li>
                                <a href="coa.php">Chart of Accounts</a>
                            </li>
                            <li>
                                <a href="trans_upload.php">Bank Statement Uploads</a>
                            </li>
                            <li>
                                <a href="pay_subscription.php">Subscription</a>
                            </li>
                        </ul>
                    </div>
                </li>
                
                <li>
                    <a href="#invoices" data-bs-toggle="collapse">
                        <i class="mdi mdi-clipboard-outline"></i>
                        <span> Invoicing </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="invoices">
                        <ul class="nav-second-level">
                            <li>
                                <a href="create_invoice.php">Create Invoices</a>
                            </li>
                            <li>
                                <a href="list_invoices.php">Invoice History</a>
                            </li>
                            <li>
                                <a href="#">Payment Reminders</a>
                            </li>
                        </ul>
                    </div>
                </li>
                
                <li>
                    <a href="#expenses" data-bs-toggle="collapse">
                        <i class="mdi mdi-clipboard-outline"></i>
                        <span> Expenses </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="expenses">
                        <ul class="nav-second-level">
                            <li>
                                <a href="add_expense.php">Create Expenses</a>
                            </li>
                            <li>
                                <a href="exp_report.php">Expense Reports</a>
                            </li>
                            <li>
                                <a href="#">Receipt Uploads & Management</a>
                            </li>
                        </ul>
                    </div>
                </li>


                <li class="menu-title mt-2">Reporting</li>
                
                <li>
                    <a href="#reports" data-bs-toggle="collapse">
                        <i class="mdi mdi-chart-donut-variant"></i>
                        <span> Financial Statements </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="reports">
                        <ul class="nav-second-level">
                            <li>
                                <a href="p_l.php">Profit & Loss</a>
                            </li>
                            <li>
                                <a href="balance_sheet.php">Balance Sheet</a>
                            </li>
                            <li>
                                <a href="trial_balance.php">Trial Balance</a>
                            </li>
                            <li>
                                <a href="income_statement.php">Income Statement</a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li>
                    <a href="#tax-reports" data-bs-toggle="collapse">
                        <i class="mdi mdi-map-outline"></i>
                        <span> Taxes </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="tax-reports">
                        <ul class="nav-second-level">
                            <li>
                                <a href="#">Tax Reports</a>
                            </li>
                            <li>
                                <a href="#">Tax Documents</a>
                            </li>
                        </ul>
                    </div>
                </li>
                
                <li class="menu-title mt-2">Settings</li>
                
                <li>
                    <a href="#settings" data-bs-toggle="collapse">
                        <i class="mdi mdi-map-outline"></i>
                        <span> My Settings </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="settings">
                        <ul class="nav-second-level">
                            <li>
                                <a href="contacts-profile.php">Profile</a>
                            </li>
                            <li>
                                <a href="#">Change Password</a>
                            </li>
                        </ul>
                    </div>
                </li>

            </ul>

        </div>
        <!-- End Sidebar -->

        <div class="clearfix"></div>

    </div>
    <!-- Sidebar -left -->

</div>
<!-- Left Sidebar End -->