<?php include 'services/session.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Add Client";
    include 'partials/title-meta.php'; ?>
    
    <link href="assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Add Client";
    include 'partials/menu.php'; ?>
            
            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">Client Data Capture</h4>
                                <p class="sub-header">Capture basic client data.</p>
                
                                <form class="needs-validation" novalidate action="save_client.php" method="post">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="client_name" class="form-label">Client Name</label>
                                                <input type="text" class="form-control" id="client_name" name="client_name" placeholder="Client Name" required />
                                            </div>
                                            <div class="mb-3">
                                                <label for="email" class="form-label">Email</label>
                                                <input type="text" class="form-control" id="email" placeholder="Email" name="email" required />
                                            </div>
                                            <div class="mb-3">
                                                <label for="phone_number" class="form-label">Phone Number</label>
                                                <input type="text" class="form-control" id="phone_number" placeholder="Phone Number" name="phone_number" required />
                                            </div>
                                            <div class="mb-3">
                                                <label for="address" class="form-label">Address</label>
                                                <textarea class="form-control" id="address" name="address" placeholder="Address" required></textarea>
                                            </div>
                                        </div>
                
                                        <div class="col-lg-6">
                                           <div class="mb-3">
                                                <label for="state" class="form-label">State</label>
                                                <select class="form-control" id="state" name="state" data-toggle="select2" required>
                                                    <option>Select State</option>
                                                    <?php
                                                    // Assuming $conn is your database connection object
                                                    require_once 'includes/dbconn.php';
                                                    
                                                    // Group states by time zone
                                                    $timeZones = [
                                                        'Alaskan/Hawaiian Time Zone' => ['AK' => 'Alaska', 'HI' => 'Hawaii'],
                                                        'Pacific Time Zone' => ['CA' => 'California', 'NV' => 'Nevada', 'OR' => 'Oregon', 'WA' => 'Washington'],
                                                        'Mountain Time Zone' => ['AZ' => 'Arizona', 'CO' => 'Colorado', 'ID' => 'Idaho', 'MT' => 'Montana', 'NE' => 'Nebraska', 'NM' => 'New Mexico', 'ND' => 'North Dakota', 'UT' => 'Utah', 'WY' => 'Wyoming'],
                                                        'Central Time Zone' => ['AL' => 'Alabama', 'AR' => 'Arkansas', 'IL' => 'Illinois', 'IA' => 'Iowa', 'KS' => 'Kansas', 'KY' => 'Kentucky', 'LA' => 'Louisiana', 'MN' => 'Minnesota', 'MS' => 'Mississippi', 'MO' => 'Missouri', 'OK' => 'Oklahoma', 'SD' => 'South Dakota', 'TX' => 'Texas', 'TN' => 'Tennessee', 'WI' => 'Wisconsin'],
                                                        'Eastern Time Zone' => ['CT' => 'Connecticut', 'DE' => 'Delaware', 'FL' => 'Florida', 'GA' => 'Georgia', 'IN' => 'Indiana', 'ME' => 'Maine', 'MD' => 'Maryland', 'MA' => 'Massachusetts', 'MI' => 'Michigan', 'NH' => 'New Hampshire', 'NJ' => 'New Jersey', 'NY' => 'New York', 'NC' => 'North Carolina', 'OH' => 'Ohio', 'PA' => 'Pennsylvania', 'RI' => 'Rhode Island', 'SC' => 'South Carolina', 'VT' => 'Vermont', 'VA' => 'Virginia', 'WV' => 'West Virginia']
                                                    ];
                                                    
                                                    // Output state options grouped by time zone
                                                    foreach ($timeZones as $timeZoneLabel => $states) {
                                                        echo "<optgroup label='$timeZoneLabel'>";
                                                        foreach ($states as $abbreviation => $stateName) {
                                                            echo "<option value='$abbreviation'>$stateName</option>";
                                                        }
                                                        echo "</optgroup>";
                                                    }
                                                    
                                                    // Close the database connection
                                                    $conn->close();
                                                    ?>

                                                </select>
                                            </div>

                                            <div class="mb-3">
                                                <label for="company" class="form-label">Company</label>
                                                <input type="text" class="form-control" id="company" name="company" placeholder="Company" />
                                            </div>
                                            <div class="mb-3">
                                                <label for="start_date" class="form-label">Start Date</label>
                                                <input type="text" class="form-control" id="start_date" name="start_date" placeholder="Company" readonly />
                                            </div>
                                             
                                        </div>
                                    </div>
                
                                    <button class="btn btn-primary" type="submit">Submit form</button>
                                </form>
                
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <?php include 'partials/footer.php'; ?>

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <?php include 'partials/right-sidebar.php'; ?>

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- Plugin js-->
        <script src="assets/libs/parsleyjs/parsley.min.js"></script>

        <!-- Validation init js-->
        <script src="assets/js/pages/form-validation.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        <script src="assets/libs/selectize/js/standalone/selectize.min.js"></script>
        <script src="assets/libs/mohithg-switchery/switchery.min.js"></script>
        <script src="assets/libs/multiselect/js/jquery.multi-select.js"></script>
        <script src="assets/libs/select2/js/select2.min.js"></script>
        <script src="assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
        <script src="assets/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
        <script src="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
        <script src="assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>
        <script>
            $(document).ready(function() {
                $('#state').select2();
            });
        </script>
        <script>
            // Get today's date
            var today = new Date();
        
            // Format it as YYYY-MM-DD (which is the format commonly used in databases)
            var formattedDate = today.toISOString().substr(0, 10);
        
            // Set the default value of the input field to today's date
            document.getElementById("start_date").value = formattedDate;
        </script>
        
    </body>
</html>